/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnExplosionStart;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.entities.EntityHelper;
import com.mlib.items.ItemHelper;
import com.mlib.math.AABBHelper;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FuseCutterEnchantment
extends CustomEnchantment {
    public FuseCutterEnchantment() {
        this.rarity(Enchantment.Rarity.UNCOMMON).category(Registries.SHIELD).slots(EquipmentSlots.BOTH_HANDS).minLevelCost(level -> 8).maxLevelCost(level -> 40);
    }

    @AutoInstance
    public static class Handler {
        static final ParticleHandler BIG_SMOKE = new ParticleHandler(ParticleTypes.f_123755_, ParticleHandler.offset((float)0.25f), () -> Float.valueOf(0.025f));
        static final ParticleHandler SMOKE = new ParticleHandler(ParticleTypes.f_123762_, ParticleHandler.offset((float)0.25f), () -> Float.valueOf(0.025f));
        final DoubleConfig maxDistance = new DoubleConfig(6.0, new Range((Number)1.0, (Number)100.0));
        final DoubleConfig cooldownRatio = new DoubleConfig(1.5, new Range((Number)0.0, (Number)10.0));
        final Supplier<FuseCutterEnchantment> enchantment = Registries.FUSE_CUTTER;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("FuseCutter").comment("Cancels all nearby explosions whenever the player is blocking with a shield.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnExplosionStart.listen(this::cancelExplosion).addCondition(Condition.isServer()).addCondition(Condition.predicate(this::isAnyoneBlockingWithFuseCutterNearby)).addConfig((IConfigurable)this.maxDistance.name("maximum_distance").comment("Maximum distance in blocks from the explosion.")).addConfig((IConfigurable)this.cooldownRatio.name("cooldown_ratio").comment("Ratio of explosion radius to disabled shield cooldown duration. (for instance 1.5 means that explosion with 2 blocks radius will disable the shield for 3 seconds)")).insertTo(group);
        }

        private void cancelExplosion(OnExplosionStart.Data data) {
            Vec3 position = data.explosion.getPosition().m_82520_(0.0, 0.5, 0.0);
            BIG_SMOKE.spawn(data.getServerLevel(), position, 8 * data.radius.intValue());
            SMOKE.spawn(data.getServerLevel(), position, 12 * data.radius.intValue());
            SoundHandler.FIRE_EXTINGUISH.play((Level)data.getServerLevel(), position);
            data.event.setCanceled(true);
        }

        private boolean isAnyoneBlockingWithFuseCutterNearby(OnExplosionStart.Data data) {
            Level level = data.getLevel();
            Vec3 position = data.explosion.getPosition();
            for (LivingEntity livingEntity : level.m_45976_(LivingEntity.class, AABBHelper.createInflatedAABB((Vec3)position, (double)((Double)this.maxDistance.get())))) {
                if (!(livingEntity instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (!livingEntity.m_21254_()) continue;
                ItemStack itemStack = ItemHelper.getCurrentlyUsedItem((LivingEntity)livingEntity);
                if (!this.enchantment.get().hasEnchantment(itemStack)) continue;
                EntityHelper.disableCurrentItem((Player)player, (double)(data.radius.doubleValue() * (Double)this.cooldownRatio.get()));
                return true;
            }
            return false;
        }
    }
}

